package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TDeviceApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TDeviceApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TDeviceApplyVO;

import java.util.List;

/**
 * 自购电脑申请
 *
 * @author lemon
 * @date 2023-09-19
 */
public interface TDeviceApplyService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TDeviceApplyVO}>
     */
    PagingVO<TDeviceApplyVO> queryPaging(TDeviceApplyQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TDeviceApplyVO}>
     */
    List<TDeviceApplyVO> queryListDynamic(TDeviceApplyQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TDeviceApplyVO}
     */
    TDeviceApplyVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TDeviceApplyVO}
     */
    TDeviceApplyVO insert(TDeviceApplyPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TDeviceApplyVO}
     */
    TDeviceApplyVO update(TDeviceApplyPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(TDeviceApplyPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
