package com.elitesland.tw.tw5.api.prd.org.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleVO;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class PrdOrgEmployeeVO extends BaseViewModel {


    @ApiModelProperty("用户账号")
    private String userName;

    @ApiModelProperty("用户最终名称")
    private String lastName;
    /**
     * 角色IDs
     */
    private List<Long> roleIds;
    /**
     * 角色数据
     */
    private List<PrdSystemRoleVO> roleDatas;

    @ApiModelProperty("用户电话")
    private String mobile;

    @ApiModelProperty("百望电话")
    private String baiwangMobile;

    @ApiModelProperty("用户邮箱")
    private String email;

    @ApiModelProperty("账户状态")
    private Boolean enabled;

    @ApiModelProperty("自然人ID")
    private Long personId;
    /**
     * 用户真实姓名
     */
    @ApiModelProperty("用户真实姓名")
    private String personName;

    @ApiModelProperty("系统用户ID")
    private Long userId;

    @ApiModelProperty("4.0系统用户ID")
    private Long userIdV4;

//    @ApiModelProperty("公司ID")
//    private Long companyId;

    @ApiModelProperty("公司bookId")
    private Long bookId;

    @ApiModelProperty("公司名称")
    private String companyName;

    @ApiModelProperty("jde公司编号")
    private String jdeCompanyNo;

    @ApiModelProperty("jde部门编号")
    private String jdeOrgCode;

    /**
     * 企业微信号
     */
    private String wecomId;

    @ApiModelProperty("员工编号")
    private String employeeNo;

    @ApiModelProperty("员工名称")
    private String employeeName;

    @ApiModelProperty("资源状态")
    private String resourceStatus;

    @ApiModelProperty("资源状态名称")
    private String resourceName;

    @ApiModelProperty("人事状态")
    private String hrStatus;//0：有效，1：无效

    @ApiModelProperty("人事状态名称")
    private String hrName;


    @ApiModelProperty("入职日期")
    private LocalDate enrollDate;

    @ApiModelProperty("安全级别")
    private Integer accessLevel;

    @ApiModelProperty("岗位")
    private String jobs;

    @ApiModelProperty("岗位名称")
    private String jobsName;

    @ApiModelProperty("排序")
    private Integer sortIndex;


    @ApiModelProperty("外文名")
    private String foreignName;

    @ApiModelProperty("证件类型")
    private String idType;

    @ApiModelProperty("证件类型名称")
    private String idTypeName;

    @ApiModelProperty("证件号码")
    private String idNo;

    @ApiModelProperty("证件开始日")
    private LocalDate idValidFrom;

    @ApiModelProperty("证件到期日")
    private LocalDate idValidTo;

    /**
     * 证件url
     */
    private String idValidCodes;
    private Object idValidDatas;

    /**
     * 头像url
     */
    private String headCodes;
    private Object headDatas;

    @ApiModelProperty("生日")
    private LocalDate birthday;

    @ApiModelProperty("性别")
    private String sex;
    @ApiModelProperty("性别名称")
    private String sexName;

    @ApiModelProperty("国籍")
    private String nationality;

    @ApiModelProperty("籍贯")
    private String birthplace;

    @ApiModelProperty("民族")
    private String nation;

    @ApiModelProperty("婚姻状况")
    private Integer marital;

    @ApiModelProperty("通讯地址")
    private String addr;

    @ApiModelProperty("紧急联系人")
    private String urgency_name;

    @ApiModelProperty("手机号")
    private String urgency_mobile;

    @ApiModelProperty("关系")
    private String urgency_ref;

    @ApiModelProperty("默认组织id")
    private Long orgId;

    @ApiModelProperty("默认组织名称")
    private String orgName;

    @ApiModelProperty("组织类型")
    private String organizationType;

    /**
     * 上级员工编号
     */
    @ApiModelProperty("上级员工编号")
    private String parentNo;

    @ApiModelProperty("上级ID")
    private Long parentId;

    /**
     * 上级员工名称
     */
    @UdcName(udcName = "USER", codePropName = "parentId")
    @ApiModelProperty("上级员工名称")
    private String parentName;

    @ApiModelProperty("组织关系")
    private List<PrdOrgDataRefVO> dataRefVOS;

    /**
     * 专业级别
     */
    private String extString1;
    /**
     * 管理级别
     */
    private String extString2;
    /**
     * 专业序列
     */
    private String extString3;
    /**
     * 职位序列
     */
    private String extString4;
    /**
     * 主服务地址
     */
    private String extString5;


    @UdcName(udcName = "org:employee:serviceaddr", codePropName = "extString5")
    private String baseCityName;
    /**
     * 内部类型
     */
    private String extString6;
    @UdcName(udcName = "org:employee:type", codePropName = "extString6")
    private String extString6Name;

    /**
     * 话费额度
     */
    private String extString7;
    /**
     * 电脑额度
     */
    private String extString8;
    /**
     * 资源类型二
     */
    private String extString9;

    private String exString9Name;

    private String extString10;
    private String extString11;
    private String extString12;
    /**
     * 离职日期
     */
    private LocalDate extDate1;
    /**
     * 转正日期
     */
    private LocalDate extDate2;
    /**
     * 合同签订日期
     */
    private LocalDate extDate3;
    /**
     * 合同到期日
     */
    private LocalDate extDate4;
    /**
     * 实习入职日期
     */
    private LocalDate extDate5;
    /**
     * 试用期开始
     */
    private LocalDate extDate6;
    /**
     * 试用期结束
     */
    private LocalDate extDate7;
    private LocalDate extDate8;

    /**
     * 当量系数
     */
    private BigDecimal eqvaRatio;


    /**
     * 帮我吧顾问id
     */
    private Long bangwo8AdviserId;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("合作方式")
    private String cooperationMode;
    @UdcName(udcName = "org:employee:COOPERATION_MODE", codePropName = "cooperationMode")
    private String cooperationModeName;

    @ApiModelProperty("资源经理")
    private Long resManagerId;

    @ApiModelProperty("参加商务培训")
    private Boolean busiTrainFlag;

    @ApiModelProperty("offer是否发放")
    private String deliverOffer;

    @ApiModelProperty("offer未发放原因")
    private String noneOfferReason;

    @ApiModelProperty("推荐人")
    private Long jobInternalRecommId;

    @ApiModelProperty("工种分类一")
    private String jobClass1;

    @ApiModelProperty("工种分类二")
    private String jobClass2;

    @ApiModelProperty("长期/短期")
    private String periodFlag;

    @ApiModelProperty("复合能力")
    private String capasetLevelId;

    @ApiModelProperty("发薪方式")
    private String salaryMethod;

    @ApiModelProperty("发薪周期")
    private String salaryPeriod;

    @ApiModelProperty("自我评价")
    private String selfEvaluation;

    @ApiModelProperty("个人简历url")
    private String resumeCodes;
    private Object resumeDatas;

    @ApiModelProperty("自我介绍视频url")
    private String selfIntroVideoCodes;
    private Object selfIntroVideoDatas;

    @ApiModelProperty("标签")
    private String selfTagging;

    @ApiModelProperty("专业技能&专业领域")
    private String professionalSkills;

    @ApiModelProperty("从业年限")
    private String professionalYears;

    /**
     * 特殊情况下 需要以一个用户对应一个角色  一一展示 角色名称
     */
    private String roleName;

    /**
     * 角色主键
     */
    private Long roleId;

    /**
     * UUID
     */
    private String uuId;

    @ApiModelProperty("服务方式")
    private String serviceType;

    @ApiModelProperty("服务时间开始")
    private LocalDate serviceClockFrom;

    @ApiModelProperty("服务时间结束")
    private LocalDate serviceClockTo;

    @ApiModelProperty("是否出差")
    private String busiTripFlag;

    @ApiModelProperty("资源编号")
    private String resNo;

    @ApiModelProperty("平台邮箱")
    private String platformEmail;

    @ApiModelProperty("实习开始日期")
    private LocalDate internshipStartDate;
}
