package com.elitesland.tw.tw5.api.prd.pms.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * BU项目成员管理
 *
 * @author carl
 * @date 2023-11-29
 */
@Getter
@Setter
public class BuProjectMembersPayload extends TwCommonPayload implements Serializable {
    /**
     * 项目ID
     */
    @ApiModelProperty("项目ID")
    private Long projId;
    /**
     * 角色
     */
    @ApiModelProperty("角色")
    private String role;
    /**
     * 复合能力ID
     */
    @ApiModelProperty("复合能力ID")
    private Long capasetLevelId;
    /**
     * 资源id
     */
    @ApiModelProperty("资源id")
    private Long resId;
    /**
     * 预计开始日期
     */
    @ApiModelProperty("预计开始日期")
    private LocalDate planStartDate;
    /**
     * 预计结束日期
     */
    @ApiModelProperty("预计结束日期")
    private LocalDate planEndDate;
    /**
     * 规划当量
     */
    @ApiModelProperty("规划当量")
    private BigDecimal planEqva;
    /**
     * 工作台默认显示
     */
    @ApiModelProperty("工作台默认显示")
    private Integer workbenchFlag;
    /**
     * 客户结算价
     */
    @ApiModelProperty("客户结算价")
    private BigDecimal customerPrice;
    /**
     * 工种子类1
     */
    @ApiModelProperty("工种子类1")
    private String jobType1;
    /**
     * 工种子类2
     */
    @ApiModelProperty("工种子类2")
    private String jobType2;
    /**
     * 复合能力级别
     */
    @ApiModelProperty("复合能力级别")
    private Long leveldId;
    /**
     * 复合能力级别
     */
    @ApiModelProperty("复合能力级别")
    private String leveldName;
//    /** 任务包ID */
//    @ApiModelProperty("任务包ID")
//    private Long taskPackageId;


    /**
     * 任务包数量
     */
    @ApiModelProperty("任务包数量")
    private Long taskPackageCount;
}
