package com.elitesland.tw.tw5.api.prd.purchase.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 付款单记录
 *
 * @author likunpeng
 * @date 2023-11-23
 */
@Getter
@Setter
public class PaymentSlipPayload extends TwCommonPayload implements Serializable {
    /**
     * 付款申请单ID
     */
    @ApiModelProperty("付款申请单ID")
    private Long paymentApplyId;

    /**
     * 付款申请单编号
     */
    @ApiModelProperty("付款申请单号")
    private String paymentApplyNo;

    /**
     * 付款流水号
     */
    @ApiModelProperty("付款流水号")
    private String paySerialNum;
    /**
     * 付款银行
     */
    @ApiModelProperty("付款银行")
    private String paymentBank;
    /**
     * 付款账号
     */
    @ApiModelProperty("付款账号")
    private String paymentAccount;
    /**
     * 付款金额
     */
    @ApiModelProperty("付款金额")
    private BigDecimal paymentAmt;
    /**
     * 付款公司地址簿Id
     */
    @ApiModelProperty("付款公司地址簿Id")
    private Long payCompanyBookId;
    /**
     * 科目说明
     */
    @ApiModelProperty("科目说明")
    private Long accMasId;
    /**
     * 付款方式
     */
    @ApiModelProperty("付款方式")
    private String paymentMethod;
    /**
     * 付款日期
     */
    @ApiModelProperty("付款日期")
    private LocalDate paymentDate;
    /**
     * 收款公司
     */
    @ApiModelProperty("收款公司")
    private Long receivingCompanyBookId;
    /**
     * 收款银行
     */
    @ApiModelProperty("收款银行")
    private String receivingBank;
    /**
     * 收款账号
     */
    @ApiModelProperty("收款账号")
    private String receivingAccount;
    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private String state;
    /**
     * 出纳更新时间
     */
    @ApiModelProperty("出纳更新时间")
    private LocalDateTime cashierTime;
    /**
     * 出纳备注
     */
    @ApiModelProperty("出纳备注")
    private String cashierRemark;
    /**
     * 应付会计更新时间
     */
    @ApiModelProperty("应付会计更新时间")
    private LocalDateTime apAccountantTime;
    /**
     * 应付会计备注
     */
    @ApiModelProperty("应付会计备注")
    private String apAccountantRemark;
    /**
     * 财务经理更新时间
     */
    @ApiModelProperty("财务经理更新时间")
    private LocalDateTime financeTime;
    /**
     * 财务经理备注
     */
    @ApiModelProperty("财务经理备注")
    private String financeRemark;
    /**
     * CFO更新时间
     */
    @ApiModelProperty("CFO更新时间")
    private LocalDateTime cfoTime;
    /**
     * CFO备注
     */
    @ApiModelProperty("CFO备注")
    private String cfoRemark;
    /**
     * 实际付款日期
     */
    @ApiModelProperty("实际付款日期")
    private LocalDate actualDate;
    /**
     * 支付时间
     */
    @ApiModelProperty("支付时间")
    private LocalDateTime payTime;
    /**
     * 支付状态：S 成功、F 失败、C  撤销、D 过期、R 否决 G退票
     */
    @ApiModelProperty("支付状态：S 成功、F 失败、C  撤销、D 过期、R 否决 G退票")
    private String payStatus;
    /**
     * 支付方式：1.网银支付 2.手动支付
     */
    @ApiModelProperty("支付方式：1.网银支付 2.手动支付")
    private Integer payMode;
    /**
     * 网银提交标识 1.已提交 2.未提交
     */
    @ApiModelProperty("网银提交标识 1.已提交 2.未提交")
    private Integer bankFlag;
    /**
     * 网银提交时间
     */
    @ApiModelProperty("网银提交时间")
    private LocalDateTime bankTime;
    /**
     * 支付标识：1.已支付 ；2.待支付
     */
    @ApiModelProperty("支付标识：1.已支付 ；2.待支付")
    private Integer payFlag;
    /**
     * 支付用途/网银用途
     */
    @ApiModelProperty("支付用途/网银用途")
    private String payPurpose;

    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /**
     * 提交时间
     */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("主键集合")
    private List<Long> keys;


    @ApiModelProperty("摘要")
    private String payProofDigest;

    @ApiModelProperty("付款记账日期")
    private LocalDateTime payAccountDate;
    @ApiModelProperty("申请单类型")
    private String paymentApplicationType;
    @ApiModelProperty("发票号稽核")
    private List<String> invoiceNos;

}
