package com.elitesland.tw.tw5.api.prd.purchase.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 付款单记录
 *
 * @author likunpeng
 * @date 2023-11-23
 */
@Getter
@Setter
public class PaymentSlipQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;

    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private List<Long> ids;

    /**
     * 付款申请单ID 精确
     */
    @ApiModelProperty("付款申请单ID")
    private Long paymentApplyId;

    /**
     * 付款申请单ID集合 精确
     */
    @ApiModelProperty("付款申请单ID集合")
    private List<Long> paymentApplyIdList;
    /**
     * 付款流水号 精确
     */
    @ApiModelProperty("付款流水号")
    private String paySerialNum;
    /**
     * 付款申请单编号
     */
    @ApiModelProperty("付款申请单编号")
    private String paymentApplyNo;
    /**
     * 付款申请人
     */
    @ApiModelProperty("付款申请人")
    private Long purchaseInchargeResId;
    /**
     * 付款公司book_id 精确
     */
    @ApiModelProperty("付款公司book_id")
    private Long payCompanyBookId;

    /**
     * 供应商地址簿id 精确
     */
    @ApiModelProperty("供应商地址簿id")
    private Long supplierBookId;
    /**
     * 付款银行 精确
     */
    @ApiModelProperty("付款银行")
    private String paymentBank;
    /**
     * 付款账号 精确
     */
    @ApiModelProperty("付款账号")
    private String paymentAccount;
    /**
     * 付款金额 精确
     */
    @ApiModelProperty("付款金额")
    private BigDecimal paymentAmt;

    /**
     * 付款事由 精确
     */
    @ApiModelProperty("付款事由")
    private String reasonDesc;

    /**
     * 付款单备注(付款申请单/预付款单子的财务信息中的申请人备注)
     */
    @ApiModelProperty("付款单备注(付款申请单/预付款单子的财务信息中的申请人备注)")
    private String accountingNote;
    /**
     * 状态 精确
     */
    @ApiModelProperty("状态")
    private String state;

    /**
     * 状态集合 精确
     */
    @ApiModelProperty("状态集合")
    private List<String> stateList;
    /**
     * 付款日期开始 精确
     */
    @ApiModelProperty("付款日期开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate paymentDateStart;

    /**
     * 付款日期结束 精确
     */
    @ApiModelProperty("付款日期结束")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate paymentDateEnd;

    /**
     * 支付方式：1.网银支付 2.手动支付 精确
     */
    @ApiModelProperty("支付方式：1.网银支付 2.手动支付")
    private Integer payMode;

    /**
     * 付款方式 精确
     */
    @ApiModelProperty("付款方式")
    private String paymentMethod;

    /**
     * 支付状态：S 成功、F 失败、C  撤销、D 过期、R 否决 G退票 精确
     */
    @ApiModelProperty("支付状态：S 成功、F 失败、C  撤销、D 过期、R 否决 G退票")
    private String payStatus;


    /**
     * 科目说明
     */
    @ApiModelProperty("科目说明")
    private Long accMasId;


    /**
     * 收款公司 精确
     */
    @ApiModelProperty("收款公司")
    private Long receivingCompanyBookId;
    /**
     * 收款银行 精确
     */
    @ApiModelProperty("收款银行")
    private String receivingBank;
    /**
     * 收款账号 精确
     */
    @ApiModelProperty("收款账号")
    private String receivingAccount;

    /**
     * 出纳更新时间 精确
     */
    @ApiModelProperty("出纳更新时间")
    private LocalDateTime cashierTime;
    /**
     * 出纳备注 精确
     */
    @ApiModelProperty("出纳备注")
    private String cashierRemark;
    /**
     * 应付会计更新时间 精确
     */
    @ApiModelProperty("应付会计更新时间")
    private LocalDateTime apAccountantTime;
    /**
     * 应付会计备注 精确
     */
    @ApiModelProperty("应付会计备注")
    private String apAccountantRemark;
    /**
     * 财务经理更新时间 精确
     */
    @ApiModelProperty("财务经理更新时间")
    private LocalDateTime financeTime;
    /**
     * 财务经理备注 精确
     */
    @ApiModelProperty("财务经理备注")
    private String financeRemark;
    /**
     * CFO更新时间
     */
    @ApiModelProperty("CFO更新时间")
    private LocalDateTime cfoTime;
    /**
     * 财务经理备注
     */
    @ApiModelProperty("CFO备注")
    private String cfoRemark;
    /**
     * 实际付款日期 精确
     */
    @ApiModelProperty("实际付款日期")
    private LocalDate actualDate;
    /**
     * 支付时间 精确
     */
    @ApiModelProperty("支付时间")
    private LocalDateTime payTime;

    /**
     * 网银提交标识 1.已提交 2.未提交 精确
     */
    @ApiModelProperty("网银提交标识 1.已提交 2.未提交")
    private Integer bankFlag;
    /**
     * 网银提交时间 精确
     */
    @ApiModelProperty("网银提交时间")
    private LocalDateTime bankTime;
    /**
     * 支付标识：1.已支付 ；2.待支付 精确
     */
    @ApiModelProperty("支付标识：1.已支付 ；2.待支付")
    private Integer payFlag;
    /**
     * 支付用途/网银用途 精确
     */
    @ApiModelProperty("支付用途/网银用途")
    private String payPurpose;

    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /**
     * 提交时间
     */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    /**
     * 付款日期开始 精确
     */
    @ApiModelProperty("付款日期开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDateTime payApprovedTimeStart;

    /**
     * 付款日期结束 精确
     */
    @ApiModelProperty("付款日期结束")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDateTime payApprovedTimeEnd;

    @ApiModelProperty("付款凭证号")
    private String payProofNo;

    @ApiModelProperty("付款凭证状态")
    private String payProofStatus;
}
