package com.elitesland.tw.tw5.api.prd.purchase.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 采购合同管理
 *
 * @author lipengfei
 * @date 2023-05-30
 */
@Getter
@Setter
public class PurchaseContractManagerQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    private List<Long> ids;
    /** 采购合同编号 精确 */
    @ApiModelProperty("采购合同编号")
    private String purchaseContractNo;
    /** 采购合同名称 精确 */
    @ApiModelProperty("采购合同名称")
    private String purchaseContractName;
    @ApiModelProperty("采购合同名称完全相等")
    private String purchaseContractNameEq;

    /** 平台合同类型 udc[salecon:plat_type] 精确 */
    @ApiModelProperty("平台合同类型 udc[salecon:plat_type]")
    private String platType;
    /** 采购合同类型 udc[purchase:con_type] 精确 */
    @ApiModelProperty("采购合同类型 udc[purchase:con_type]")
    private String purchaseContractType;
    /** 业务类型 udc[purchase:business_type] 精确 */
    @ApiModelProperty("业务类型 udc[purchase:business_type]")
    private String businessType;
    /** 验收方式 udc[purchase:check] 精确 */
    @ApiModelProperty("验收方式 udc[purchase:check]")
    private String acceptanceType;
    /** 采购公司地址簿Id 精确 */
    @ApiModelProperty("采购公司地址簿Id")
    private Long purchaseCompanyBookId;
    /** 供应商地址簿ID 精确 */
    @ApiModelProperty("供应商地址簿ID")
    private Long supplierBookId;
    /** 采购BU 精确 */
    @ApiModelProperty("采购BU")
    private Long purchaseBuId;
    /** 采购负责人 精确 */
    @ApiModelProperty("采购负责人")
    private Long purchaseInchargeResId;
    /** 签约日期 精确 */
    @ApiModelProperty("签约日期开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate signDateStart;
    /** 签约日期 精确 */
    @ApiModelProperty("签约日期结束")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate signDateEnd;
    /** 申请日期 精确 */
    @ApiModelProperty("申请日期开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate applicationDateStart;
    /** 申请日期 精确 */
    @ApiModelProperty("申请日期结束")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate applicationDateEnd;
    /** 币种 udc[SYSTEM_BASIC:CURRENCY] 精确 */
    @ApiModelProperty("币种 udc[SYSTEM_BASIC:CURRENCY]")
    private String currCode;
    /** 金额 精确 */
    @ApiModelProperty("金额")
    private BigDecimal amt;
    /** 税率 精确 */
    @ApiModelProperty("税率")
    private String taxRate;
    /** 税额 精确 */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /** 合同状态 精确 */
    @ApiModelProperty("合同状态")
    private String contractStatus;
    /** 审批状态 精确 */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    /** 关联销售合同 精确 */
    @ApiModelProperty("关联销售合同")
    private Long relatedSalesContract;
    /** 关联协议 精确 */
    @ApiModelProperty("关联协议")
    private Long relatedAgreement;
    /** 需求编号 精确 */
    @ApiModelProperty("需求编号")
    private String demandNo;
    /** 比价资料 精确 */
    @ApiModelProperty("比价资料")
    private String pricecompereFileCodes;
    /** 合同附件 精确 */
    @ApiModelProperty("合同附件")
    private String contractFileCodes;
    /** 盖章附件 精确 */
    @ApiModelProperty("盖章附件")
    private String stampFileCodes;
    /** 项目ID 精确 */
    @ApiModelProperty("项目ID")
    private Long relatedProjectId;
    /** 项目名称 精确 */
    @ApiModelProperty("项目名称")
    private String relatedProjectName;
    /** 任务包 精确 */
    @ApiModelProperty("任务包")
    private Long relatedTask;
    /** 开票方 精确 */
    @ApiModelProperty("开票方")
    private Long invoice;
    /** 付款方式 精确 */
    @ApiModelProperty("付款方式")
    private String payMethod;
    /** 采购来源 精确 */
    @ApiModelProperty("采购来源")
    private String contractSource;
    /** 采购来源编号 精确 */
    @ApiModelProperty("采购来源编号")
    private String contractSourceNo;
    /** 激活时间 精确 */
    @ApiModelProperty("激活时间")
    private LocalDateTime activateDate;
    /** 终止原因 精确 */
    @ApiModelProperty("终止原因")
    private String overWhy;
    /** 终止时间 精确 */
    @ApiModelProperty("终止时间")
    private LocalDateTime overDate;
    /** 合同归档标志，0：未归档，1：归档 精确 */
    @ApiModelProperty("合同归档标志，0：未归档，1：归档")
    private Integer filingFlag;

    /** 流程实例ID */
    @ApiModelProperty("流程实例ID")
    private String procInstId;

    /** 提交时间 */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    /** 审批时间 */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    /** 产品大类 */
    @ApiModelProperty("产品大类")
    private Long classId;

    /**
     * 合同名称/编号
     */
    @ApiModelProperty("合同名称/编号")
    private String contractNmNo;
    @ApiModelProperty("采购合同名称/编号")
    private String purContractNmNo;

    /**
     * 项目名称/编号
     */
    @ApiModelProperty("项目名称/编号")
    private String projNmNo;
}
