package com.elitesland.tw.tw5.api.prd.purchase.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseContractManagerPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseContractManagerQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseContractManagerVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentDefaultVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 采购合同管理
 *
 * @author lipengfei
 * @date 2023-05-30
 */
public interface PurchaseContractManagerService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PurchaseContractManagerVO}>
     */
    PagingVO<PurchaseContractManagerVO> queryPaging(PurchaseContractManagerQuery query);

    /**
     * 权限分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PurchaseContractManagerVO}>
     */
    PagingVO<PurchaseContractManagerVO> queryPermissionPaging(PurchaseContractManagerQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PurchaseContractManagerVO}>
     */
    List<PurchaseContractManagerVO> queryListDynamic(PurchaseContractManagerQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PurchaseContractManagerVO}
     */
    PurchaseContractManagerVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PurchaseContractManagerVO}
     */
    PurchaseContractManagerVO insert(PurchaseContractManagerPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PurchaseContractManagerVO}
     */
    PurchaseContractManagerVO update(PurchaseContractManagerPayload payload);
    /**
     * 更新
     *
     * @param payload 单据数据
     * @return {@link PurchaseContractManagerVO}
     */
    long updateByKeyDynamic(PurchaseContractManagerPayload payload);
    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

//    /**
//     * @return
//     * @Description 列表查询
//     **/
//    List<PrdAbVO> abQueryList(String relateType);

    /**
     * 查询日志列表
     *
     * @param key 关键
     * @return {@link List}<{@link PrdSystemLogVO}>
     */
    List<PrdSystemLogVO> queryLogList(Long key);

    /**
     * 激活
     *
     * @param keys 主键集合
     */
    Long active(List<Long> keys);

    /**
     * 合同归档
     *
     * @param ids 主键
     * @return result
     */
    void contractFilingByIds(List<Long> ids);

    /**
     * 根据主键修改采购合同状态
     *
     * @param ids
     * @param closeReason 关闭原因
     * @return int
     */
    void closeContract(List<Long> ids, String closeReason);

    /**
     * 采购合同自动关闭批处理
     *
     * @return 更新条数
     */
    Integer purchaseContractCloseBatch();

    /**
     * 导出
     *
     * @param response 请求响应
     * @param query    查询条件
     */
    void downloadPurCon(HttpServletResponse response, PurchaseContractManagerQuery query);

    /**
     * 带权限-导出
     *
     * @param response 请求响应
     * @param query    查询条件
     */
    void permissionDownloadPurCon(HttpServletResponse response, PurchaseContractManagerQuery query);

    PurchaseContractManagerVO selectPurchaseContractByOverId(Long overId);

    /**
     * 通过合同编号查询付款申请单前置数据
     * @param docNo 合同编号
     * @return 付款申请单前置数据
     */
    PurchasePaymentDefaultVO findPaymentDefaultByDocNo(String docNo);

    /**
     * 通过合同编号查询合同Id
     * @param docNo 合同编号
     * @return 合同Id
     */
    Long findIdByNo(String docNo);

    /**
     * 通过合同编号查询合同详情
     * @param docNo 合同编号
     * @return 合同Id
     */
    PurchaseContractManagerVO queryByNo(String docNo);

    /**
     * 合同归档
     * @param purConId 归档合同Id
     * @param stampFileCodes 盖章附件
     */
    void purContractArchiving(Long purConId, String stampFileCodes);

    /**
     * 根据销售合同id查看采购合同列表
     *
     * @param saleConId 销售合同Id
     * @return 采购合同列表
     */
    List<PurchaseContractManagerVO>  queryBySaleConId(Long saleConId);
}
