package com.elitesland.tw.tw5.api.prd.purchase.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.TPurchaseContractOverPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.TPurchaseContractOverQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.TPurchaseContractOverVO;

import java.util.List;

/**
 * 采购合同终止
 *
 * @author lemon
 * @date 2023-10-19
 */
public interface TPurchaseContractOverService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TPurchaseContractOverVO}>
     */
    PagingVO<TPurchaseContractOverVO> queryPaging(TPurchaseContractOverQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TPurchaseContractOverVO}>
     */
    List<TPurchaseContractOverVO> queryListDynamic(TPurchaseContractOverQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TPurchaseContractOverVO}
     */
    TPurchaseContractOverVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TPurchaseContractOverVO}
     */
    TPurchaseContractOverVO insert(TPurchaseContractOverPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TPurchaseContractOverVO}
     */
    TPurchaseContractOverVO update(TPurchaseContractOverPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(TPurchaseContractOverPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
