package com.elitesland.tw.tw5.api.prd.salecon.service;

import com.elitesland.tw.tw5.api.prd.salecon.payload.ConAchieveDPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConAchieveDQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConAchieveDVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 业绩统计明细
 *
 * @author likunpeng
 * @date 2023-04-24
 */
public interface ConAchieveDService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link ConAchieveDVO}>
     */
    PagingVO<ConAchieveDVO> queryPaging(ConAchieveDQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link ConAchieveDVO}>
     */
    List<ConAchieveDVO> queryListDynamic(ConAchieveDQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link ConAchieveDVO}
     */
    ConAchieveDVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link ConAchieveDVO}
     */
    ConAchieveDVO insert(ConAchieveDPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link ConAchieveDVO}
     */
    ConAchieveDVO update(ConAchieveDPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
