package com.elitesland.tw.tw5.api.prd.salecon.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConPurchaseDemandDPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConPurchaseDemandDQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConPurchaseDemandDVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 采购需求处理明细
 *
 * @author likunpeng
 * @date 2023-03-29
 */
public interface ConPurchaseDemandDService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link ConPurchaseDemandDVO}>
     */
    PagingVO<ConPurchaseDemandDVO> paging(ConPurchaseDemandDQuery query);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link ConPurchaseDemandDVO}>
     */
    PagingVO<ConPurchaseDemandDVO> queryPaging(ConPurchaseDemandDQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link ConPurchaseDemandDVO}>
     */
    List<ConPurchaseDemandDVO> queryList(ConPurchaseDemandDQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link ConPurchaseDemandDVO}>
     */
    List<ConPurchaseDemandDVO> queryListDynamic(ConPurchaseDemandDQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link ConPurchaseDemandDVO}
     */
    ConPurchaseDemandDVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link ConPurchaseDemandDVO}
     */
    ConPurchaseDemandDVO insert(ConPurchaseDemandDPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link ConPurchaseDemandDVO}
     */
    ConPurchaseDemandDVO update(ConPurchaseDemandDPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 根据采购需求ID查询明细
     * @param purDemandId
     * @return List<ConPurchaseDemandDVO>
     */
    List<ConPurchaseDemandDVO> queryByPurDemandId(Long purDemandId);
    /**
     * 批量导出活动excel
     *
     * @param query 查询条件
     * @return result
     */
    void downloadPurDemand(HttpServletResponse response, ConPurchaseDemandDQuery query);

}
