package com.elitesland.tw.tw5.api.prd.system.service;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemFinPeriodPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFinPeriodQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFinPeriodVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFinYearVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 财务期间
 *
 * @author likunpeng
 * @date 2023-04-12
 */
public interface PrdSystemFinPeriodService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PrdSystemFinPeriodVO}>
     */
    PagingVO<PrdSystemFinPeriodVO> queryPaging(PrdSystemFinPeriodQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PrdSystemFinPeriodVO}>
     */
    List<PrdSystemFinPeriodVO> queryListDynamic(PrdSystemFinPeriodQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PrdSystemFinPeriodVO}
     */
    PrdSystemFinPeriodVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PrdSystemFinPeriodVO}
     */
    PrdSystemFinPeriodVO insert(PrdSystemFinPeriodPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PrdSystemFinPeriodVO}
     */
    PrdSystemFinPeriodVO update(PrdSystemFinPeriodPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
