package com.elitesland.tw.tw5.api.prd.acc.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingOverduePayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingOverdueQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingContinuousVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingOverdueVO;

import javax.servlet.http.HttpServletResponse;
import java.time.LocalDate;
import java.util.List;

/**
 * 报销逾期配置
 *
 * @author zoey
 * @date 2024-04-08
 */
public interface AccReimSettingOverdueService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AccReimSettingOverdueVO}>
     */
    PagingVO<AccReimSettingOverdueVO> queryPaging(AccReimSettingOverdueQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AccReimSettingOverdueVO}>
     */
    List<AccReimSettingOverdueVO> queryListDynamic(AccReimSettingOverdueQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AccReimSettingOverdueVO}
     */
    AccReimSettingOverdueVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AccReimSettingOverdueVO}
     */
    AccReimSettingOverdueVO insert(AccReimSettingOverduePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link AccReimSettingOverdueVO}
     */
    AccReimSettingOverdueVO update(AccReimSettingOverduePayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(AccReimSettingOverduePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 规则校验
     * @param key
     * @param invoiceNo
     * @return
     */
    AccReimSettingOverdueVO ruleCheck(Long key, String expenseDate,String invoiceNo,Long reimUserId);
}
