package com.elitesland.tw.tw5.api.prd.acc.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimTaxPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimTaxQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimExportVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimTaxVO;

import java.util.List;
import java.util.Set;

/**
 * 费用报销税额管理
 *
 * @author sunxw
 * @date 2023-12-05
 */
public interface AccReimTaxService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AccReimTaxVO}>
     */
    PagingVO<AccReimTaxVO> queryPaging(AccReimTaxQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AccReimTaxVO}>
     */
    List<AccReimTaxVO> queryListDynamic(AccReimTaxQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AccReimTaxVO}
     */
    AccReimTaxVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AccReimTaxVO}
     */
    AccReimTaxVO insert(AccReimTaxPayload payload);

    /**
     * 批量插入
     *
     * @param payloadList
     * @return
     */
    long batchInsert(List<AccReimTaxPayload> payloadList);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link AccReimTaxVO}
     */
    AccReimTaxVO update(AccReimTaxPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(AccReimTaxPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 更新报销单明细时删除税额，重新赋值
     *
     * @param reimId
     */
    void delByReimId(Long reimId);

    /**
     * 获取税额的导出数据
     *
     * @param idList
     * @return
     */
    List<AccReimExportVO> getExportTaxData(Set<Long> idList);
}
