package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;

/**
 * 人脉-教育经历
 *
 * @author carl
 * @date 2022/12/07
 */
@Data
public class CrmPeopleEducatePayload extends TwCommonPayload {
    /**
     * 人脉主键
     */
    private Long peopleId;

    /**
     * 学校
     */
    private String school;

    /**
     * 学历
     */
    private String education;
    /**
     * 专业
     */
    private String major;
    /**
     * 开始
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate startDate;
    /**
     * 结束
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate endDate;

}
