package com.elitesland.tw.tw5.api.prd.humanresources.service;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdRecruitPositionPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdRecruitPositionQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdRecruitPositionVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 内部招聘管理
 *
 * @author zhangxiao
 * @date 2023-12-13
 */
public interface PrdRecruitPositionService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PrdRecruitPositionVO}>
     */
    PagingVO<PrdRecruitPositionVO> queryPaging(PrdRecruitPositionQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PrdRecruitPositionVO}>
     */
    List<PrdRecruitPositionVO> queryListDynamic(PrdRecruitPositionQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PrdRecruitPositionVO}
     */
    PrdRecruitPositionVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PrdRecruitPositionVO}
     */
    PrdRecruitPositionVO insert(PrdRecruitPositionPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PrdRecruitPositionVO}
     */
    PrdRecruitPositionVO update(PrdRecruitPositionPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PrdRecruitPositionPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
