package com.elitesland.tw.tw5.api.prd.partner.business.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.business.payload.BusinessOperationEnterpriseInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.business.query.BusinessOperationEnterpriseInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.business.vo.BusinessOperationEnterpriseInfoVO;

import java.util.List;

/**
 * 业务伙伴-企业基本信息
 *
 * @author wangly
 * @date 2023-05-16
 */
public interface BusinessOperationEnterpriseInfoService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessOperationEnterpriseInfoVO}>
     */
    PagingVO<BusinessOperationEnterpriseInfoVO> queryPaging(BusinessOperationEnterpriseInfoQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessOperationEnterpriseInfoVO}>
     */
    List<BusinessOperationEnterpriseInfoVO> queryListDynamic(BusinessOperationEnterpriseInfoQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessOperationEnterpriseInfoVO}
     */
    BusinessOperationEnterpriseInfoVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessOperationEnterpriseInfoVO}
     */
    BusinessOperationEnterpriseInfoVO insert(BusinessOperationEnterpriseInfoPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessOperationEnterpriseInfoVO}
     */
    BusinessOperationEnterpriseInfoVO update(BusinessOperationEnterpriseInfoPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 通过partnerId删除
     *
     * @param partnerId 业务伙伴id
     */
    void deleteByPartnerId(Long partnerId);
}
