package com.elitesland.tw.tw5.api.prd.salecon.vo;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;


/**
  * 业绩统计明细
  *
  * @author likunpeng
  * @date 2023-04-24
  */
@Getter
@Setter
public class ConAchieveDVO extends BaseViewModel implements Serializable {
    /** 业绩统计ID */
    @ApiModelProperty("业绩统计ID")
    private Long achieveId;
    /** 部门类别 */
    @ApiModelProperty("部门类别")
    private String buType;
    @UdcName(udcName = "con:achieve:department", codePropName = "buType")
    private String buTypeDesc;
    /** 部门ID */
    @ApiModelProperty("部门ID")
    private Long buId;
    @UdcName(udcName = "BU", codePropName = "buId")
    @ApiModelProperty("业绩归属部门")
    private String buName;
    /** 业绩类别 */
    @ApiModelProperty("业绩类别")
    private String achieveType;
    @UdcName(udcName = "con:achieve:type", codePropName = "achieveType")
    private String achieveTypeDesc;
    /** 价值角色 */
    @ApiModelProperty("价值角色")
    private String valueRole;
    @UdcName(udcName = "con:achieve:role", codePropName = "valueRole")
    private String valueRoleDesc;
    /** 部门归属人员ID */
    @ApiModelProperty("部门归属人员ID")
    private Long chargeResId;
    @UdcName(udcName = "USER", codePropName = "chargeResId")
    @ApiModelProperty("部门归属人员")
    private String chargeResName;
    /** 分配比例 */
    @ApiModelProperty("分配比例")
    private String ratio;
    /** 分配金额 */
    @ApiModelProperty("分配金额")
    private BigDecimal amt;
    /** 主合同编号 */
    @ApiModelProperty("主合同编号")
    private String mainConCode;
    /** 主合同Id */
    @ApiModelProperty("主合同Id")
    private Long mainConId;
    /** 主合同名称 */
    @ApiModelProperty("主合同名称")
    private String mainConName;
    /** 子合同编号 */
    @ApiModelProperty("子合同编号")
    private String subConCode;
    /** 子合同Id */
    @ApiModelProperty("子合同Id")
    private Long subConId;
    /** 子合同名称 */
    @ApiModelProperty("子合同名称")
    private String subConName;
    /** 子合同状态 */
    @ApiModelProperty("合同状态")
    private String subConStatus;
    @UdcName(udcName = "salecon:status", codePropName = "subConStatus")
    private String subConStatusDesc;
    /** 客户ID */
    @ApiModelProperty("客户ID")
    private Long custId;
    /** 客户名称 */
    @ApiModelProperty("客户名称")
    private String custName;
    /** 签单日期 */
    @ApiModelProperty("签单日期")
    private LocalDate signDate;
    /** 子合同签单金额 */
    @ApiModelProperty("子合同签单金额")
    private BigDecimal signAmt;
    /** 子合同有效金额 */
    @ApiModelProperty("子合同有效金额")
    private BigDecimal effectiveAmt;
    /** 签单BU_ID */
    @Comment("签单BU_ID")
    private Long signBuId;
    @ApiModelProperty("签单BU_Name")
    @UdcName(udcName = "BU", codePropName = "signBuId")
    private String signBuName;
    /** 销售区域BU_ID */
    @ApiModelProperty("销售区域BU_ID")
    private Long regionBuId;
    @ApiModelProperty("销售区域BU_Name")
    @UdcName(udcName = "BU", codePropName = "regionBuId")
    private String regionBuName;
    /** 销售负责人 */
    @ApiModelProperty("销售负责人")
    private Long saleManUserId;
    /** 销售负责人 */
    @UdcName(udcName = "USER", codePropName = "saleManUserId")
    private String saleManUserName;
    /**  交付BU_ID */
    @ApiModelProperty("交付BU_ID")
    private Long deliBuId;
    /** 交付BU名称 */
    @UdcName(udcName = "BU", codePropName = "deliBuId")
    private String deliBuName;
    /** 交付负责人ID*/
    @ApiModelProperty("交付负责人ID")
    private Long deliUserId;
    /**  交付负责人名称 */
    @UdcName(udcName = "USER", codePropName = "deliUserId")
    private String deliUserName;
    /**  PMO用户ID */
    @ApiModelProperty("PMO用户ID")
    private Long pmoUserId;
    /** PMO用户名称 */
    @UdcName(udcName = "USER", codePropName = "pmoUserId")
    private String pmoUserName;
    private Long achievedIdV4;

}
