package com.elitesland.tw.tw5.api.prd.system.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemSiteRefPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemSiteRefQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSiteRefVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 业务地点关系表
 *
 * @author zoey
 * @date 2024-04-22
 */
public interface PrdSystemSiteRefService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PrdSystemSiteRefVO}>
     */
    PagingVO<PrdSystemSiteRefVO> queryPaging(PrdSystemSiteRefQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PrdSystemSiteRefVO}>
     */
    List<PrdSystemSiteRefVO> queryListDynamic(PrdSystemSiteRefQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PrdSystemSiteRefVO}
     */
    PrdSystemSiteRefVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PrdSystemSiteRefVO}
     */
    PrdSystemSiteRefVO insert(PrdSystemSiteRefPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PrdSystemSiteRefVO}
     */
    PrdSystemSiteRefVO update(PrdSystemSiteRefPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PrdSystemSiteRefPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
