package com.elitesland.tw.tw5.api.prd.adm.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmFeeApplyDetailPayload;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmFeeApplyDetailQuery;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmFeeApplyDetailVO;

import java.util.List;

/**
 * 特殊费用申请明细管理
 *
 * @author carl
 * @date 2023-11-01
 */
public interface AdmFeeApplyDetailService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AdmFeeApplyDetailVO}>
     */
    PagingVO<AdmFeeApplyDetailVO> queryPaging(AdmFeeApplyDetailQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AdmFeeApplyDetailVO}>
     */
    List<AdmFeeApplyDetailVO> queryListDynamic(AdmFeeApplyDetailQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AdmFeeApplyDetailVO}
     */
    AdmFeeApplyDetailVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AdmFeeApplyDetailVO}
     */
    AdmFeeApplyDetailVO insert(AdmFeeApplyDetailPayload payload);


    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(AdmFeeApplyDetailPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 批量新增或修改
     *
     * @param payloads 单据数据
     */
    List<AdmFeeApplyDetailVO> bacthInsert(List<AdmFeeApplyDetailPayload> payloads);

    /**
     * 根据申请id逻辑删除
     *
     * @param applyIds 申请id
     */
    void deleteSoftByApplyId(List<Long> applyIds);

}
