package com.elitesland.tw.tw5.api.prd.cal.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalAccountFreezePayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalAccountFreezeQuery;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalAccountFreezeVO;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalAccountTurnoverVO;

import java.util.List;

/**
 * 核算-账户冻结记录管理
 *
 * @author carl
 * @date 2023-11-13
 */
public interface CalAccountFreezeService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link CalAccountFreezeVO}>
     */
    PagingVO<CalAccountFreezeVO> queryPaging(CalAccountFreezeQuery query);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link CalAccountFreezeVO}
     */
    CalAccountFreezeVO insert(CalAccountFreezePayload payload);

    /**
     * 批量新增
     *
     * @param payloads 单据数据
     * @return {@link CalAccountTurnoverVO}
     */
    void batchInsert(List<CalAccountFreezePayload> payloads);
//    /**
//     * 查询列表
//     *
//     * @param query 条件参数
//     * @return {@link List}<{@link CalAccountFreezeVO}>
//     */
//    List<CalAccountFreezeVO> queryListDynamic(CalAccountFreezeQuery query);
//
//    /**
//     * 通过主键查询
//     *
//     * @param key 主键
//     * @return {@link CalAccountFreezeVO}
//     */
//    CalAccountFreezeVO queryByKey(Long key);
//

//
//    /**
//     * 修改
//     *
//     * @param payload 单据数据
//     * @return {@link CalAccountFreezeVO}
//     */
//    CalAccountFreezeVO update(CalAccountFreezePayload payload);
//
//    /**
//     * 修改,置空的字段需需要借助 protected List<String> nullFields;
//     *
//     * @param payload 单据数据
//     * @return {@link long}
//     */
//    long updateByKeyDynamic(CalAccountFreezePayload payload);

//    /**
//     * 逻辑删除
//     *
//     * @param keys 主键集合
//     */
//    void deleteSoft(List<Long> keys);

}
