package com.elitesland.tw.tw5.api.prd.crm.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Author carl.wang
 * @Description 商机表
 * @Date
 **/

@Data

public class CrmOpportunityQuery extends TwQueryParam {


    /**
     * 商机id列表
     */
    private Long[] oppoIds;
    private List<Long> ids;
    private List<Long> oppoIdsV4;

    /**
     * 项目名称（活动名称）/项目编号（活动编号）
     */
    private String projectNameOrNo;


    /**
     * 签单负责人id
     */
    private Long manageUserId;
    /**
     * 签单buid
     */
    private Long orgId;
    /**
     * 公司id
     */
    private Long companyId;
    /**
     * 附件urls（“，”分割字符串）
     */
    private String fileUrls;

    /**
     * 项目id
     */
    private Long projectId;
    private List<Long> projectIds;
    /**
     * 项目状态类型0：等于，1：不等于
     */
    private String projectStatusType;
    /**
     * 项目状态
     */
    private String projectStatus;

    /**
     * 关闭原因
     */
    private String closeReson;

    /**
     * 关闭备注
     */
    private String clsoeRemark;

    /**
     * 线索id
     */
    private Long leadsId;
    /**
     * 销售产品
     */
    private String saleProduct;
    /**
     * 客户区域
     */
    private String custRegion;
    /**
     * 是否老客户 0:Y,1:N
     */
    private Integer isOldCust;
    /**
     * 客户id 老客户才会选择
     */
    private Long custBookId;
    /**
     * 客户名称
     */
    private String custBookName;
    /**
     * 客户项目
     */
    private String custProject;
    /**
     * 客户联系人
     */
    private String contactName;
    /**
     * 客户联系电话
     */
    private String contactPhone;
    /**
     * 客户联系人部门
     */
    private String contactDept;
    /**
     * 客户联系人岗位
     */
    private String contactPosition;
    /**
     * 企业主页
     */
    private String contactWebsite;
    /**
     * 客户性质
     */
    private String custProp;
    /**
     * 客户行业
     */
    private String custIdst;
    /**
     * 预计成单日期范围
     */
    private String forecastWinDateRange;
    /**
     * 预计签单金额
     */
    private BigDecimal forecastAmount;
    /**
     * 预计签单金额
     */
    private BigDecimal forecastAmountStart;
    /**
     * 预计签单金额
     */
    private BigDecimal forecastAmountEnd;
    /**
     * 成单概率
     */
    private String probability;
    /**
     * 币种
     */
    private String currCode;
    /**
     * 销售阶段
     */
    @ApiModelProperty("销售阶段")
    private String salePhase;
    /**
     * 销售阶段
     */
    @ApiModelProperty("销售阶段")
    private List<String> salePhases;

    /**
     * 交付地点
     */
    private String deliveryAddress;
    /**
     * 商机级别
     */
    private String oppoLevel;
    /**
     * 商机级别s
     */
    private List<String> oppoLevels;
    /**
     * 是否需要合作伙伴 0:Y,1:N
     */
    private Integer isNeedPartner;
    /**
     * 关联合作伙伴Id
     */
    private Long coopBookId;
    /**
     * 关联合作伙伴名称
     */
    private String coopBookName;
    /**
     * 合作伙伴描述
     */
    private String partnerDesc;
    /**
     * 售前bu
     */
    private Long preSaleOrgId;
    /**
     * 售前bu
     */
    private List<Long> preSaleOrgIds;
    /**
     * 售前负责人
     */
    private Long preSaleUserId;
    /**
     * 项目难度
     */
    private String projectDifficult;
    /**
     * 项目重要度
     */
    private String projectImportance;
    /**
     * 交付BU_ID
     */
    private Long deliOrgId;
    /**
     * 交付负责人ID
     */
    private Long deliUserId;
    /**
     * 方案难度
     */
    private String solutionDifficulty;
    /**
     * 方案重要度
     */
    private String solutionImportance;
    /**
     * 合作(副)签单BU_ID
     */
    private Long coOrgId;
    /**
     * 合作(副)签单负责人ID
     */
    private Long coUserId;
    /**
     * 合作(副)交付BU_ID
     */
    private Long codeliOrgId;
    /**
     * 合作(副)交付负责人ID
     */
    private Long codeliUserId;
    /**
     * 来源类型
     */
    private String sourceType;
    /**
     * 内部来源BU_ID
     */
    private Long internalOrgId;
    /**
     * 内部来源人ID
     */
    private Long internalUserId;
    /**
     * 外部线索来源
     */
    private String externalIden;
    /**
     * 外部来源人
     */
    private String externalName;
    /**
     * 外部来源电话
     */
    private String externalPhone;
    /**
     * 利益承诺
     */
    private String profitDesc;

    /**
     * 关联正式客户id
     */
    private Long formalCustomerId;

    /**
     * 是否需要权限判断
     */
    private Boolean isPermission = false;

    private String extString1;
    private String extString2;
    private String extString3;
    private String extString4;
    private String extString5;

    /**
     * 验证状态
     */
    private String checkStatus;

    /**
     * 资源规划标志
     */
    @ApiModelProperty("资源规划标志")
    private Boolean personPlanFlag;

    /**
     * 资源规划类型
     */
    @ApiModelProperty("资源规划类型")
    private String planType;


    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private List<LocalDateTime> createTimeBetween;

//    /**
//     * 业务伙伴主键
//     */
//    private Long partnerId;

    /**
     * 用户，用传入的用户替代当前登录人的权限
     */
    private Long queryUserId;

}
