package com.elitesland.tw.tw5.api.prd.my.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

@Getter
@Setter
public class RewardLeaveApplyDetailVO extends BaseViewModel implements Serializable {
    /**
     * 申请单id
     */
    @ApiModelProperty("申请单id")
    private Long applyId;
    /**
     * 资源userId
     */
    @ApiModelProperty("资源userId")
    private Long userId;
    @ApiModelProperty("资源")
    @UdcName(udcName = "USER", codePropName = "userId")
    private String userName;
    /**
     * 职级
     */
    @ApiModelProperty("职级")
    private String jobGrade;

    /**
     * 管理职级
     */
    @ApiModelProperty("管理职级")
    private String jobGrade2;
    
    /**
     * 资源组织Id
     */
    @ApiModelProperty("资源组织Id")
    private Long orgId;
    @ApiModelProperty("组织")
    @UdcName(udcName = "BU", codePropName = "orgId")
    private String orgName;
    /**
     * 工作日期
     */
    @ApiModelProperty("工作日期")
    private LocalDate workDate;
    /**
     * 工作类型
     */
    @ApiModelProperty("工作类型")
    private String workType;
    /**
     * 奖励假天数
     */
    @ApiModelProperty("奖励假天数")
    private BigDecimal days;
    /**
     * 理论当量
     */
    @ApiModelProperty("理论当量")
    private BigDecimal eqva;
    /**
     * 已申请天数
     */
    @ApiModelProperty("已申请天数")
    private BigDecimal appliedDays;

    /**
     * 事由类型
     */
    @ApiModelProperty("事由类型")
    private String reasonType;
    @UdcName(udcName = "PMS:PROJECT:TYPE", codePropName = "reasonType")
    private String reasonTypeName;
    /**
     * 事由号
     */
    @ApiModelProperty("事由id")
    private Long reasonId;
    /**
     * 事由号
     */
    @ApiModelProperty("事由号")
    private String reasonName;

    @ApiModelProperty("主服务地")
    private String extString5;
    @UdcName(udcName = "org:employee:serviceaddr", codePropName = "extString5")
    private String extString5Name;

    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

}

