package com.elitesland.tw.tw5.api.prd.partner.common.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;

/**
 * 业务伙伴-联系信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Getter
@Setter
public class BookContactsQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 地址薄id 精确 */
    @ApiModelProperty("地址薄id")
    private Long bookId;
    /** 地址薄id 精确 */
    @ApiModelProperty("地址薄id")
    private List<Long> bookIdList;
    /** 联系人类型 精确 */
    @ApiModelProperty("联系人类型")
    private String contactsType;
    /** 联系人姓名 精确 */
    @ApiModelProperty("联系人姓名")
    private String contactsName;
    /** 联系人手机 精确 */
    @ApiModelProperty("联系人手机")
    private String contactsPhone;
    /** 联系人电话 精确 */
    @ApiModelProperty("联系人电话")
    private String contactsTelephone;
    /** 邮箱 精确 */
    @ApiModelProperty("邮箱")
    private String contactsEmail;
    /** 联系地址 精确 */
    @ApiModelProperty("联系地址")
    private String contactsAddress;
    /** 社交账户类型 精确 */
    @ApiModelProperty("社交账户类型")
    private String socialAccountType;
    /** 社交账户 精确 */
    @ApiModelProperty("社交账户")
    private String socialAccount;
    /** 部门 精确 */
    @ApiModelProperty("部门")
    private String contactsDepartment;
    /** 岗位 精确 */
    @ApiModelProperty("岗位")
    private String contactsPosition;
    /** 联系人关系 精确 */
    @ApiModelProperty("联系人关系")
    private String contactsRelation;
    /** 性别 udc[org:employee:sex] 精确 */
    @ApiModelProperty("性别 udc[org:employee:sex]")
    private String sex;
    /** 生日 精确 */
    @ApiModelProperty("生日")
    private LocalDate birthday;
    /** 是否是关键决策人 精确 */
    @ApiModelProperty("是否是关键决策人")
    private Boolean isKeyPerson;
    /** 联系人编号 精确 */
    @ApiModelProperty("联系人编号")
    private String contactsNo;
    /** 联系人状态 精确 */
    @ApiModelProperty("联系人状态")
    private String contactsStatus;
    /** 是否为默认联系人信息 精确 */
    @ApiModelProperty("是否为默认联系人信息")
    private Boolean isDefault;
}
