package com.elitesland.tw.tw5.api.prd.partner.common.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BookAddressPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookAddressQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookAddressVO;

import java.util.List;

/**
 * 业务伙伴-地址信息
 *
 * @author wangly
 * @date 2023-05-16
 */
public interface BookAddressService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BookAddressVO}>
     */
    PagingVO<BookAddressVO> queryPaging(BookAddressQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BookAddressVO}>
     */
    List<BookAddressVO> queryListDynamic(BookAddressQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BookAddressVO}
     */
    BookAddressVO queryByKey(Long key);

    /**
     * 根据bookId查询默认地址
     *
     * @param bookId bookId
     * @return {@link BookAddressVO}
     */
    BookAddressVO queryDefaultByBookId(Long bookId);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @param logFlag 是否需要操作记录日志
     * @return {@link BookAddressVO}
     */
    BookAddressVO insert(BookAddressPayload payload, Boolean logFlag);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @param logFlag 是否需要操作记录日志
     * @return {@link BookAddressVO}
     */
    BookAddressVO update(BookAddressPayload payload,Boolean logFlag);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     * @param bookId bookId
     * @param partnerId 业务伙伴主键 business_partner.id
     * @param logFlag 是否需要操作记录
     *
     */
    void deleteSoft(List<Long> keys,Long bookId,Long partnerId,Boolean logFlag);
    /**
     * 查询数量
     *
     * @param query 单据数据
     * @return Long 条数
     */

    Long count(BookAddressQuery query);

    /**
     * 根据bookId查询地址列表
     *
     * @param bookId bookId
     * @return {@link List<BookAddressVO>}
     */
    List<BookAddressVO> queryByBookId(Long bookId);
//    /**
//     * 4.0同步地址信息查询
//     *
//     * @param bookIdList bookId
//     * @return {@link List<BookAddressVO>}
//     */
//    List<PrdAbAddressPayload> queryTwBookAddressListByBookId(List<Long> bookIdList);
}
