package com.elitesland.tw.tw5.api.prd.partner.identity.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessDistributorInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.query.BusinessDistributorInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessDistributorInfoVO;

import java.util.List;

/**
 * 业务伙伴-经销商信息
 *
 * @author wangly
 * @date 2023-05-16
 */
public interface BusinessDistributorInfoService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessDistributorInfoVO}>
     */
    PagingVO<BusinessDistributorInfoVO> queryPaging(BusinessDistributorInfoQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessDistributorInfoVO}>
     */
    List<BusinessDistributorInfoVO> queryListDynamic(BusinessDistributorInfoQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessDistributorInfoVO}
     */
    BusinessDistributorInfoVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessDistributorInfoVO}
     */
    BusinessDistributorInfoVO insert(BusinessDistributorInfoPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessDistributorInfoVO}
     */
    BusinessDistributorInfoVO update(BusinessDistributorInfoPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
