package com.elitesland.tw.tw5.api.prd.pms.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 项目模板
 *
 * @author xxb
 * @date 2023-08-02
 */
@Getter
@Setter
public class PmsProjectTemplatePayload extends TwCommonPayload implements Serializable {
    /**
     * 模板名称
     */
    @ApiModelProperty("模板名称")
    private String templateName;
    /**
     * 适用项目类型
     */
    @ApiModelProperty("适用项目类型")
    private String suitProjectType;
    /**
     * 适用BU类型
     */
    @ApiModelProperty("适用BU类型")
    private String tmplType;
    /**
     * 科目模板
     */
    @ApiModelProperty("科目模板")
    private Long subjectTemplateId;
    /**
     * 状态
     */
    @ApiModelProperty("是否启用  0:禁用，1：启用")
    private Integer templateStatus;

    @ApiModelProperty("资源规划周期: WEEK周 MONTH月")
    private String resourcePlanningCycle;

    /**
     * 适用bu
     */
    @ApiModelProperty("适用bu")
    private String baseBu;

    /**
     * 适用buId
     */
    @ApiModelProperty("适用buId")
    private Long baseBuId;


    @ApiModelProperty("活动列表")
    private List<PmsProjectTemplateActPayload> actList;

}
