package com.elitesland.tw.tw5.api.prd.salecon.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConEpibolyCostConDPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConEpibolyCostConDQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConEpibolyCostConDVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * 外包费用确认明细
 *
 * @author likunpeng
 * @date 2023-04-17
 */
public interface ConEpibolyCostConDService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link ConEpibolyCostConDVO}>
     */
    PagingVO<ConEpibolyCostConDVO> queryPaging(ConEpibolyCostConDQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link ConEpibolyCostConDVO}>
     */
    List<ConEpibolyCostConDVO> queryListDynamic(ConEpibolyCostConDQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link ConEpibolyCostConDVO}
     */
    ConEpibolyCostConDVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link ConEpibolyCostConDVO}
     */
    ConEpibolyCostConDVO insert(ConEpibolyCostConDPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link ConEpibolyCostConDVO}
     */
    ConEpibolyCostConDVO update(ConEpibolyCostConDPayload payload);

    /**
     * 修改
     *
     * @param payload 根据主键动态修改单条数据
     */
    Long updateByKeyDynamic(ConEpibolyCostConDPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 提交确认费用明细
     *
     * @param contractId
     */
    void submission(Long contractId, Long dId);

    /**
     * 按金额拆分明细
     *
     * @param amt
     * @param parentId
     */
    ConEpibolyCostConDVO splitMoney(BigDecimal amt, Long parentId);

    /**
     * 根据父明细查询子明细
     *
     * @param parentId
     * @return
     */
    List<ConEpibolyCostConDVO> queryByParentId(Long parentId);
}
