package com.elitesland.tw.tw5.api.prd.salecon.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvSettingPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvSettingQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingVO;
import org.springframework.web.bind.annotation.PathVariable;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * ConInvSettingController
 *
 * @author zoey
 * @date 2024-03-14
 */
public interface ConInvSettingService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link ConInvSettingVO}>
     */
    PagingVO<ConInvSettingVO> queryPaging(ConInvSettingQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link ConInvSettingVO}>
     */
    List<ConInvSettingVO> queryListDynamic(ConInvSettingQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link ConInvSettingVO}
     */
    ConInvSettingVO queryByKey(Long key);

    /**
     * 通过部门和年度查询
     *
     * @param invOuId 部门id
     * @param invOuId 年度
     * @return {@link ConInvSettingVO}
     */
    ConInvSettingVO queryByInvOuIdAndYear(Long invOuId, Integer invYear);

    /**
     * 插入校验
     * @param payload
     * @return
     */
    Integer insertCheck(ConInvSettingPayload payload);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link ConInvSettingVO}
     */
    ConInvSettingVO insert(ConInvSettingPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link ConInvSettingVO}
     */
    ConInvSettingVO update(ConInvSettingPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(ConInvSettingPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);


}
