package com.elitesland.tw.tw5.api.prd.system.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.List;

/**
 * 数据权限
 *
 * @Author Bill
 * @Date 2023/9/25 14:14
 **/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class PrdSystemPermissionRulePayload extends TwCommonPayload {

    /**
     * 对象主键
     */
    private Long objectId;

    /**
     * 规则编号
     */
    private String ruleCode;

    /**
     * 规则类型
     */
    private String ruleType;

    /**
     * 规则范围
     */
    private String ruleScope;

    /**
     * 规则范围名称
     */
    private String ruleScopeName;

    /**
     * 规则表达式
     */
    private String groupExpr;

    /**
     * 规则明细
     */
    private List<PrdSystemPermissionRuleDetailPayload> detailList;

    /**
     * 功能主键
     */
    private Long functionId;

    /**
     * 业务对象类型
     */
    private String ruleSubType;

    /**
     * 明细细节
     */
    private String levelScope;

    /**
     * 范围类型
     */
    private String scopeType;

    /**
     * 是否下钻
     */
    private Integer deep;

}
