package com.elitesland.tw.tw5.api.prd.system.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 系统快捷入口
 *
 * @author wangly
 * @date 2024-03-28
 */
@Getter
@Setter
public class PrdSystemShortcutQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 快捷入口名称 精确
     */
    @ApiModelProperty("快捷入口名称")
    private String shortcutName;
    /**
     * 快捷入口前端路由 精确
     */
    @ApiModelProperty("快捷入口前端路由")
    private String portalRoute;
    /**
     * 快捷入口图标 精确
     */
    @ApiModelProperty("快捷入口图标")
    private String shortcutIcon;
    /**
     * 快捷入口排序 精确
     */
    @ApiModelProperty("快捷入口排序")
    private Integer sortIndex;
    /**
     * 快捷入口状态 精确
     */
    @ApiModelProperty("快捷入口状态 1是 0否")
    private Integer shortcutStatus;
    /**
     * 类型 精确
     */
    @ApiModelProperty("类型")
    private String type;

    /**
     * 类型集合 精确
     */
    @ApiModelProperty("类型集合")
    private List<String> typeList;
    /**
     * web类型 pc app 精确
     */
    @ApiModelProperty("web类型 pc app")
    private String webType;
    /**
     * 是否固定(固定后app页面不能移动) 精确
     */
    @ApiModelProperty("是否固定(固定后app页面不能移动)")
    private Boolean fixFlag;
}
