package com.elitesland.tw.tw5.api.prd.cal.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 核算-账户冻结记录管理
 *
 * @author carl
 * @date 2023-11-13
 */
@Getter
@Setter
public class CalAccountFreezeQuery extends TwQueryParam implements Serializable {
    /**
     * 主键 精确
     */
    @ApiModelProperty("主键")
    private Long id;

    /**
     * 账户id
     */
    @ApiModelProperty("账户id")

    private Long accId;
    /**
     * 账户名称（冗余）
     */
    @ApiModelProperty("账户名称（冗余）")
    private String accName;

    /**
     * 核算年度 精确
     */
    @ApiModelProperty("核算年度")
    private Integer finYear;
    /**
     * 核算期间 精确
     */
    @ApiModelProperty("核算期间")
    private Integer finPeriod;
    /**
     * 交易期间
     */
    @ApiModelProperty("交易期间")
    private LocalDate ioDate;
    /**
     * 交易期间开始日期 精确
     */
    @ApiModelProperty("交易期间开始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate ioStartDate;
    /**
     * 交易期间结束日期 精确
     */
    @ApiModelProperty("交易期间结束日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate ioEndDate;
    /**
     * 交易时间 精确
     */
    @ApiModelProperty("交易时间")
    private LocalDateTime ioTime;
    /**
     * 交易单据类型 精确
     */
    @ApiModelProperty("交易单据类型")
    private String sourceType;
    /**
     * 交易单据id 精确
     */
    @ApiModelProperty("交易单据id")
    private Long sourceId;
    /**
     * 交易单据名称（冗余） 模糊
     */
    @ApiModelProperty("交易单据名称（冗余）")
    private String sourceName;
    /**
     * 冻结当量 精确
     */
    @ApiModelProperty("冻结当量")
    private BigDecimal freezeQty;
    /**
     * 当量价格 精确
     */
    @ApiModelProperty("当量价格")
    private BigDecimal eqvaPrice;
    /**
     * 交易前当量 精确
     */
    @ApiModelProperty("交易前当量")
    private BigDecimal beforeQty;
    /**
     * 交易后当量 精确
     */
    @ApiModelProperty("交易后当量")
    private BigDecimal afterQty;
    /**
     * 交易前金额 精确
     */
    @ApiModelProperty("交易前金额")
    private BigDecimal beforeAmt;
    /**
     * 交易后金额 精确
     */
    @ApiModelProperty("交易后金额")
    private BigDecimal afterAmt;
}
