package com.elitesland.tw.tw5.api.prd.cal.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 当量成本配置管理
 *
 * @author carl
 * @date 2023-11-07
 */
@Getter
@Setter
public class CalEqvaCostVO extends BaseViewModel implements Serializable {
    /**
     * 平台编号
     */
    @ApiModelProperty("平台编号")
    private String busifieldType;
    @UdcName(udcName = "CAL:BUSI:TYPE", codePropName = "busifieldType")
    private String busifieldTypeDesc;
    /**
     * buid
     */
    @ApiModelProperty("buid")
    private Long buId;
    @UdcName(udcName = "BU", codePropName = "buId")
    private String buName;
    /**
     * 当量名称
     */
    @ApiModelProperty("当量名称")
    private String eqvaName;
    /**
     * 工种
     */
    @ApiModelProperty("工种")
    private String jobType1;
    @UdcName(udcName = "org:employee:multiCapacity", codePropName = "jobType1")
    private String jobType1Desc;
    /**
     * 工种子类
     */
    @ApiModelProperty("工种子类")
    private String jobType2;
    @UdcName(udcName = "org:employee:multiCapacity", codePropName = "jobType2")
    private String jobType2Desc;
    /**
     * 核算年度
     */
    @ApiModelProperty("核算年度")
    private Integer finYear;
    /**
     * 核算期间
     */
    @ApiModelProperty("核算期间")
    private Integer finPeriod;
    /**
     * 核算期间
     */
    @ApiModelProperty("核算期间")
    private String finPeriodName;
    /**
     * 当量成本
     */
    @ApiModelProperty("当量成本")
    private BigDecimal eqvaCost;
}
