package com.elitesland.tw.tw5.api.prd.crm.vo;

import com.elitesland.tw.tw5.api.udc.UdcName;
import com.elitescloud.boot.common.param.BaseViewModel;
import lombok.Data;

import java.util.List;

/**
 * 客户经营-经营计划模板
 *
 * @author duwh
 * @date 2022/11/15
 */
@Data
public class CrmOperationPlanTempVO extends BaseViewModel {

    /**
     * 名字
     */
    private String name;

    /**
     * 类型 udc[crm:cust_oper:type]
     */
    private String custType;
    @UdcName(udcName = "crm:cust_oper:type", codePropName = "custType")
    private String custTypeDesc;

    /**
     * 客户级别 udc[crm:cust_oper:cust_grade]
     * 类型、客户级别 确定唯一
     * <p>
     * 特例：类型为 政府、组织及协会、生态伙伴的时候  客户级别为99 默认展示一级
     */
    private String custGrade;
    @UdcName(udcName = "crm:cust_oper:cust_grade", codePropName = "custGrade")
    private String custGradeDesc;

    /**
     * 计划明细集合
     */
    private List<CrmOperationPlanTempDetailVO> detailList;

    private String ext1;

    private String ext2;

    private String ext3;

    private String ext4;

    private String ext5;


}
