package com.elitesland.tw.tw5.api.prd.inv.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 发票单据关联管理
 *
 * @author sunxw
 * @date 2023-12-06
 */
@Getter
@Setter
public class InvInvoiceDocRefQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 发票ID 精确
     */
    @ApiModelProperty("发票ID")
    private Long invId;
    /**
     * 关联单据类型 EXPENSE-报销 精确
     */
    @ApiModelProperty("关联单据类型 EXPENSE-报销")
    private String docType;
    /**
     * 关联单据ID 精确
     */
    @ApiModelProperty("关联单据ID")
    private Long docId;
    /**
     * 关联单据明细ID 精确
     */
    @ApiModelProperty("关联单据明细ID")
    private Long docDtlId;
}
