package com.elitesland.tw.tw5.api.prd.inv.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;


/**
  * 发票商品对象（百望）
  *
  * @author zoey
  * @date 2023-07-31
  */
@Getter
@Setter
public class InvItemVO extends BaseViewModel implements Serializable {
    /** 省份 */
    @ApiModelProperty("省份")
    private String province;
    /** 商品编码（税务局） */
    @ApiModelProperty("商品编码（税务局）")
    private String goodsCode;
    /** 商品编码名称（税务局） */
    @ApiModelProperty("商品编码名称（税务局）")
    private String goodsCodeName;
    /** 商品编码（TW） */
    @ApiModelProperty("商品编码（TW）")
    private String twGoodsCode;
    /** 商品编码名称（TW） */
    @ApiModelProperty("商品编码名称（TW）")
    private String twGoodsCodeName;
    /** 商品编号 */
    @ApiModelProperty("商品编号")
    private String goodsNo;
    /** 商品名称 */
    @ApiModelProperty("商品名称")
    private String goodsName;
    /** 商品税率 */
    @ApiModelProperty("商品税率")
    private Double goodsTaxRate;
    /** 含税标志 N：不含税 Y：含税 */
    @ApiModelProperty("含税标志 N：不含税 Y：含税")
    private String priceTaxMark;
    /** 是否使用优惠政策 0:未使用，1:使用 */
    @ApiModelProperty("是否使用优惠政策 0:未使用，1:使用")
    private String preferentialMark;
    /** 优惠政策类型 preferentialMark=Y 必填 preferentialMark =N 不必填 */
    @ApiModelProperty("优惠政策类型 preferentialMark=Y 必填 preferentialMark =N 不必填")
    private String preferentialType;
    /** 说商品说明 */
    @ApiModelProperty("说商品说明")
    private String goodsDescribe;
    /** 商品简码 */
    @ApiModelProperty("商品简码")
    private String goodsShorthand;
    /** 规格型号 */
    @ApiModelProperty("规格型号")
    private String goodsSpecification;
    /** 计量单位 */
    @ApiModelProperty("计量单位")
    private String goodsUnit;
    /** 商品单价 */
    @ApiModelProperty("商品单价")
    private BigDecimal goodsPrice;
    /** 免税类型 0:正常税率；1:出口免税或其他免税优惠政策；2不征增值税；3普通零税率，默认为0 */
    @ApiModelProperty("免税类型 0:正常税率；1:出口免税或其他免税优惠政策；2不征增值税；3普通零税率，默认为0")
    private String freeTaxType;

    /**
     * 子类
     */
    private List<InvItemVO> children;
}
