package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.RewardLeaveApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.RewardLeaveAppliedQuery;
import com.elitesland.tw.tw5.api.prd.my.query.RewardLeaveApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.RewardAppliedDaysVO;
import com.elitesland.tw.tw5.api.prd.my.vo.RewardLeaveApplyDetailVO;
import com.elitesland.tw.tw5.api.prd.my.vo.RewardLeaveApplyVO;

import java.util.List;

public interface RewardLeaveApplyService {


    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link RewardLeaveApplyVO}>
     */
    PagingVO<RewardLeaveApplyVO> queryPaging(RewardLeaveApplyQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link RewardLeaveApplyVO}>
     */
    List<RewardLeaveApplyVO> queryListDynamic(RewardLeaveApplyQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link RewardLeaveApplyVO}
     */
    RewardLeaveApplyVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link RewardLeaveApplyVO}
     */
    RewardLeaveApplyVO insert(RewardLeaveApplyPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link RewardLeaveApplyVO}
     */
    RewardLeaveApplyVO update(RewardLeaveApplyPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(RewardLeaveApplyPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);


    /**
     * 提交
     *
     * @param payload 单据数据
     * @return {@link RewardLeaveApplyVO}
     */
    RewardLeaveApplyVO submit(RewardLeaveApplyPayload payload);

    List<RewardLeaveApplyDetailVO> queryRewardDetailByVacationId(Long vacationId);

    List<RewardAppliedDaysVO> countDaysByUserAndReason(RewardLeaveAppliedQuery query);

}
