package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TaskAuthorizedPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TaskAuthorizedQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TaskAuthorizedVO;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * 任务包授权主表
 *
 * @author duwh
 * @date 2022-12-16
 */
public interface TaskAuthorizedService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TaskAuthorizedVO}>
     */
    PagingVO<TaskAuthorizedVO> paging(TaskAuthorizedQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TaskAuthorizedVO}>
     */
    List<TaskAuthorizedVO> queryList(TaskAuthorizedQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TaskAuthorizedVO}
     */
    TaskAuthorizedVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TaskAuthorizedVO}
     */
    TaskAuthorizedVO insert(TaskAuthorizedPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TaskAuthorizedVO}
     */
    TaskAuthorizedVO update(TaskAuthorizedPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * Excel导出数据
     *
     * @param all      待导出的数据
     * @param response /
     * @throws IOException /
     */
    void download(List<TaskAuthorizedVO> all, HttpServletResponse response) throws IOException;

    Map<Long, Long> getV4AndV5AuthIds();
}
