package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetSubsidySettingPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetSubsidySettingQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetSubsidySettingVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 工时补贴标准配置表
 *
 * @author duwh
 * @date 2024-07-13
 */
public interface TimesheetSubsidySettingService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TimesheetSubsidySettingVO}>
     */
    PagingVO<TimesheetSubsidySettingVO> queryPaging(TimesheetSubsidySettingQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TimesheetSubsidySettingVO}>
     */
    List<TimesheetSubsidySettingVO> queryListDynamic(TimesheetSubsidySettingQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TimesheetSubsidySettingVO}
     */
    TimesheetSubsidySettingVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TimesheetSubsidySettingVO}
     */
    TimesheetSubsidySettingVO insert(TimesheetSubsidySettingPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TimesheetSubsidySettingVO}
     */
    TimesheetSubsidySettingVO update(TimesheetSubsidySettingPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(TimesheetSubsidySettingPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
