package com.elitesland.tw.tw5.api.prd.pay.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 支付管理-支付履历
 *
 * @author wangly
 * @date 2023-12-12
 */
@Getter
@Setter
public class TDocHistQuery extends TwQueryParam implements Serializable {
    /**
     * 主键id 精确
     */
    @ApiModelProperty("主键id")
    private Long id;
    /**
     * 履历类型 精确
     */
    @ApiModelProperty("履历类型")
    private String histType;
    /**
     * 履历详细 精确
     */
    @ApiModelProperty("履历详细")
    private String histDtl;
    /**
     * 履历日期时间 精确
     */
    @ApiModelProperty("履历日期时间")
    private LocalDateTime histTime;
    /**
     * 单据id 精确
     */
    @ApiModelProperty("单据id")
    private Long docId;
    /**
     * 单据编号 精确
     */
    @ApiModelProperty("单据编号")
    private String docNo;
    /**
     * 单据类型 精确
     */
    @ApiModelProperty("单据类型")
    private String docType;
    /**
     * 用户id
     */
    @ApiModelProperty("用户id")
    private Long ownerId;
}
