package com.elitesland.tw.tw5.api.prd.pms.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsDistributeRespondPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsDistributeRespondQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsDistributeRespondVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 派发响应
 *
 * @author xxb
 * @date 2023-10-08
 */
public interface PmsDistributeRespondService {


    /**
     *感兴趣/不感兴趣
     * @param list
     * @param respStatus
     */
    void respond(List<PmsDistributeRespondPayload> list, String respStatus);

    /**
     * 批量谢绝响应
     * @param ids
     * @return
     */
    void rejectRespond(List<Long> ids);

    /**
     * 批量 保存 响应信息
     * @param respondPayloads
     */
    void batchSave(List<PmsDistributeRespondPayload> respondPayloads,Long disId);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsDistributeRespondVO}>
     */
    PagingVO<PmsDistributeRespondVO> queryPaging(PmsDistributeRespondQuery query);


    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsDistributeRespondVO}>
     */
    List<PmsDistributeRespondVO> queryListDynamic(PmsDistributeRespondQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsDistributeRespondVO}
     */
    PmsDistributeRespondVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PmsDistributeRespondVO}
     */
    PmsDistributeRespondVO insert(PmsDistributeRespondPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PmsDistributeRespondVO}
     */
    PmsDistributeRespondVO update(PmsDistributeRespondPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PmsDistributeRespondPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     *  根据指派ID  删除 响应数据
     * @param distIds
     * @return
     */
    void deleteByDistIds(List<Long> distIds);

}
