package com.elitesland.tw.tw5.api.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsInnerProjectApplyPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsInnerProjectApplyQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsInnerProjectApplyVO;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;

import java.util.List;

/**
 * 内部项目申请
 *
 * @author carl
 * @date 2023-08-23
 */
public interface PmsInnerProjectApplyService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PmsInnerProjectApplyVO}>
     */
    PagingVO<PmsInnerProjectApplyVO> queryPaging(PmsInnerProjectApplyQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PmsInnerProjectApplyVO}>
     */
    List<PmsInnerProjectApplyVO> queryListDynamic(PmsInnerProjectApplyQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PmsInnerProjectApplyVO}
     */
    PmsInnerProjectApplyVO queryByKey(Long key);


    /**
     * 添加项目id
     */
    void addProject(long id, long projId);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PmsInnerProjectApplyVO}
     */
    PmsInnerProjectApplyVO save(PmsInnerProjectApplyPayload payload);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PmsInnerProjectApplyVO}
     */
    PmsInnerProjectApplyVO insert(PmsInnerProjectApplyPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PmsInnerProjectApplyVO}
     */
    PmsInnerProjectApplyVO update(PmsInnerProjectApplyPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PmsInnerProjectApplyPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 创建虚拟合同
     *
     * @param id
     */
    void createContract(long id);

    /**
     * 任务创建回调
     *
     * @param payload
     */
    void taskCreated(TaskCreatedPayload payload);

    /**
     * 流程回调
     *
     * @param payload
     */
    void processStatusChange(ProcessStatusChangePayload payload);
}
