package com.elitesland.tw.tw5.api.prd.sale.service;

import com.elitesland.tw.tw5.api.prd.sale.payload.SaleContractCategoryPayload;
import com.elitesland.tw.tw5.api.prd.sale.query.SaleContractCategoryQuery;
import com.elitesland.tw.tw5.api.prd.sale.vo.SaleContractCategoryVO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

/**
 * 合同类别
 *
 * @author duwh
 * @date 2022/09/27
 */
public interface SaleContractCategoryService {

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link SaleContractCategoryVO}
     */
    SaleContractCategoryVO insert(SaleContractCategoryPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link SaleContractCategoryVO}
     */
    SaleContractCategoryVO update(SaleContractCategoryPayload payload);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    SaleContractCategoryVO queryByKey(Long key);

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link List}<{@link SaleContractCategoryVO}>
     */
    List<SaleContractCategoryVO> queryList(SaleContractCategoryQuery query);

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<SaleContractCategoryVO> paging(SaleContractCategoryQuery query);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
