package com.elitesland.tw.tw5.api.prd.salecon.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConEpibolyCostConPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConEpibolyCostConQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConEpibolyCostConVO;

import java.util.List;

/**
 * 外包费用确认单
 *
 * @author likunpeng
 * @date 2023-04-17
 */
public interface ConEpibolyCostConService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link ConEpibolyCostConVO}>
     */
    PagingVO<ConEpibolyCostConVO> queryPaging(ConEpibolyCostConQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link ConEpibolyCostConVO}>
     */
    List<ConEpibolyCostConVO> queryListDynamic(ConEpibolyCostConQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link ConEpibolyCostConVO}
     */
    ConEpibolyCostConVO queryByKey(Long key);


    ConEpibolyCostConVO queryOneByCostDId(Long key);
    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link ConEpibolyCostConVO}
     */
    ConEpibolyCostConVO insert(ConEpibolyCostConPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link ConEpibolyCostConVO}
     */
    ConEpibolyCostConVO update(ConEpibolyCostConPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 根据合同Id查询外包费用单
     * @param saleConId
     * @return ConEpibolyCostConVO
     */
    ConEpibolyCostConVO queryByContractId(Long saleConId);

    @Deprecated
    void syncCostConTo4(String param);

    /**
     * 解绑单据
     * @param reimId
     */
    void unbindReim(String reimNo);
}
