package com.elitesland.tw.tw5.api.prd.administration.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * 资质证照
 *
 * @author wangly
 * @date 2023-09-20
 */
@Getter
@Setter
public class CertificationLicensePayload extends TwCommonPayload  implements Serializable {
    /** 证件类型 udc[COM:LICENSE_TYPE] */
    @ApiModelProperty("证件类型 udc[COM:LICENSE_TYPE]")
    private String licenseType;
    /** 证照名称 */
    @ApiModelProperty("证照名称")
    private String licenseName;
    /** 时间类型 udc[COM:TIME_TYPE] */
    @ApiModelProperty("时间类型 udc[COM:TIME_TYPE]")
    private String timeType;
    /** 有效日期起 */
    @ApiModelProperty("有效日期起")
    private LocalDate validDateStart;
    /** 有效日期止 */
    @ApiModelProperty("有效日期止")
    private LocalDate validDateEnd;
    /** 附件 */
    @ApiModelProperty("附件")
    private String fileCode;
    /** 证照来源 */
    @ApiModelProperty("证照来源")
    private String licenseSource;
    /** 证照描述 */
    @ApiModelProperty("证照描述")
    private String licenseDesc;
    /** 排序号 */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /** 扩展字段1 */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /** 扩展字段2 */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /** 扩展字段3 */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /** 扩展字段4 */
    @ApiModelProperty("扩展字段4")
    private String ext4;
    /** 扩展字段5 */
    @ApiModelProperty("扩展字段5")
    private String ext5;
}
