package com.elitesland.tw.tw5.api.prd.cal.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 当量结算定价管理
 *
 * @author carl
 * @date 2023-11-07
 */
@Getter
@Setter
public class CalSettlePriceQuery extends TwQueryParam implements Serializable {
    /**
     * 主键 精确
     */
    @ApiModelProperty("主键")
    private Long id;
    /**
     * from bu结算类型码 精确
     */
    @ApiModelProperty("from bu结算类型码")
    private String fromBuDealtype;
    /**
     * to bu结算类型码 精确
     */
    @ApiModelProperty("to bu结算类型码")
    private String toBuDealtype;
    /**
     * from bu_id 精确
     */
    @ApiModelProperty("from bu_id")
    private Long fromBuId;
    /**
     * to bu_id 精确
     */
    @ApiModelProperty("to bu_id")
    private Long toBuId;
    /**
     * 工种 精确
     */
    @ApiModelProperty("工种")
    private String jobType1;
    /**
     * 工种子类 精确
     */
    @ApiModelProperty("工种子类")
    private String jobType2;
    /**
     * 核算年度 精确
     */
    @ApiModelProperty("核算年度")
    private Integer finYear;
    /**
     * 核算期间
     */
    @ApiModelProperty("核算期间")
    private Integer finPeriod;
    /**
     * 项目id 精确
     */
    @ApiModelProperty("项目id")
    private Long projId;
    /**
     * 资源id 精确
     */
    @ApiModelProperty("资源id")
    private Long resId;
    /**
     * 定价策略（mark up百分比，mark up金额，绝对结算金额） 精确
     */
    @ApiModelProperty("定价策略（mark up百分比，mark up金额，绝对结算金额）")
    private String priceStrategy;
    /**
     * 调整价格（mark up百分比，mark up金额，绝对结算金额） 精确
     */
    @ApiModelProperty("调整价格（mark up百分比，mark up金额，绝对结算金额）")
    private BigDecimal markupPrice;
}
