package com.elitesland.tw.tw5.api.prd.humanresources.query;

import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * @author : WWW
 * @date : 2023-11-24
 * @desc : 评价表
 */

@Data
@ApiModel(description = "评价表")
public class PrdEvaluateQuery extends TwQueryParam {


    /**
     * 来源id
     */
    @ApiModelProperty("来源id")
    private Long fromId;

    /**
     * 配置id
     */
    @ApiModelProperty("配置id")
    private Long configId;

    /**
     * 评价对象名称
     */
    @ApiModelProperty("评价对象名称")
    private String itemName;

    /**
     * 评价类别
     */
    @ApiModelProperty("评价类别")
    private String cate;

    /**
     * 评价类型
     */
    @ApiModelProperty("评价类型")
    private String type;

    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long proId;

    /**
     * 任务id
     */
    @ApiModelProperty("任务id")
    private Long taskId;

    /**
     * 活动id
     */
    @ApiModelProperty("活动id")
    private Long actId;

    /**
     * 评价说明
     */
    @ApiModelProperty("评价说明")
    private String evalDesc;

    /**
     * 评价日期
     */
    @ApiModelProperty("评价日期")
    private LocalDate evalDate;

    /**
     * 评价人
     */
    @ApiModelProperty("评价人")
    private String evalUser;

    /**
     * 评价人id
     */
    @ApiModelProperty("评价人id")
    private Long evalUserId;

    /**
     * 被评价人
     */
    @ApiModelProperty("被评价人")
    private String toEvalUser;

    /**
     * 被评价人id
     */
    @ApiModelProperty("被评价人id")
    private Long toEvalUserId;

    /**
     * 平均分数
     */
    @ApiModelProperty("平均分数")
    private BigDecimal averageScore;

    /**
     * 评价日期开始
     */
    @ApiModelProperty("评价日期开始")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate evalDateStart;

    /**
     * 评价日期结束
     */
    @ApiModelProperty("评价日期结束")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate evalDateEnd;


    /**
     * 平均分数开始
     */
    @ApiModelProperty("平均分数开始")
    private BigDecimal averageScoreStart;

    /**
     * 平均分数结束
     */
    @ApiModelProperty("平均分数结束")
    private BigDecimal averageScoreEnd;

    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private Integer state;
}

