package com.elitesland.tw.tw5.api.prd.humanresources.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdCompositeAbilityPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdCompositeAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdCompositeAbilityVO;

import java.util.List;


/**
 * @author : WWW
 * @date : 2023-10-23
 * @desc : 复合能力Service
 */

public interface PrdCompositeAbilityService {

    /**
     * 新增复合能力数据
     *
     * @param prdCompositeAbilityPayload
     * @return
     */
    PrdCompositeAbilityVO save(PrdCompositeAbilityPayload prdCompositeAbilityPayload);

    /**
     * 根据主键更新
     *
     * @param prdCompositeAbilityPayload
     * @return
     */
    PrdCompositeAbilityVO update(PrdCompositeAbilityPayload prdCompositeAbilityPayload);

    /**
     * 根据主键获取详情
     *
     * @param id
     * @return
     */
    PrdCompositeAbilityVO get(Long id);

    /**
     * 分页查询列表
     *
     * @param prdCompositeAbilityQuery
     * @return
     */
    PagingVO<PrdCompositeAbilityVO> page(PrdCompositeAbilityQuery prdCompositeAbilityQuery);

    /**
     * 根据主键批量删除
     *
     * @param ids
     * @return
     */
    Long del(List<Long> ids);

    /**
     * 获取列表查询
     *
     * @param prdCompositeAbilityQuery
     * @return
     */
    List<PrdCompositeAbilityVO> getList(PrdCompositeAbilityQuery prdCompositeAbilityQuery);

    /**
     * 修改复合能力状态
     *
     * @param prdCompositeAbilityPayload
     * @return
     */
    Long updateState(PrdCompositeAbilityPayload prdCompositeAbilityPayload);


    /**
     * 查询复合能力级别定义明细分页
     *
     * @param prdCompositeAbilityQuery
     * @return
     */
    PagingVO<PrdCompositeAbilityVO> levelPage(PrdCompositeAbilityQuery prdCompositeAbilityQuery);

    /**
     * 查询复合能力级别定义明细列表
     *
     * @param prdCompositeAbilityQuery
     * @return
     */
    List<PrdCompositeAbilityVO> levelList(PrdCompositeAbilityQuery prdCompositeAbilityQuery);

    /**
     * 查询复合能力级别定义明细列表
     *
     * @param abilityLevelId
     * @return
     */
    PrdCompositeAbilityVO findByAbilityLevelId(Long abilityLevelId);


    Boolean changeName(PrdCompositeAbilityQuery prdCompositeAbilityQuery);
}

