package com.elitesland.tw.tw5.api.prd.humanresources.service;

import java.util.List;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluateDtlPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateDtlQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateDtlVO;

import javax.servlet.http.HttpServletResponse;


/**
 * @author : WWW
 * @date : 2023-11-24
 * @desc : 评价明细表Service
 */

public interface PrdEvaluateDtlService {

    /**
     * 新增评价明细表数据
     *
     * @param prdEvaluateDtlPayload
     * @return
     */
    PrdEvaluateDtlVO save(PrdEvaluateDtlPayload prdEvaluateDtlPayload);

    /**
     * 根据主键更新
     *
     * @param prdEvaluateDtlPayload
     * @return
     */
    PrdEvaluateDtlVO update(PrdEvaluateDtlPayload prdEvaluateDtlPayload);

    /**
     * 根据主键获取详情
     *
     * @param id
     * @return
     */
    PrdEvaluateDtlVO get(Long id);

    /**
     * 分页查询列表
     *
     * @param prdEvaluateDtlQuery
     * @return
     */
    PagingVO<PrdEvaluateDtlVO> page(PrdEvaluateDtlQuery prdEvaluateDtlQuery);

    /**
     * 根据主键批量删除
     *
     * @param ids
     * @return
     */
    Long del(List<Long> ids);

    /**
     * 获取列表查询
     *
     * @param prdEvaluateDtlQuery
     * @return
     */
    List<PrdEvaluateDtlVO> getList(PrdEvaluateDtlQuery prdEvaluateDtlQuery);

    /**
     * 根据条件修改
     *
     * @param prdEvaluateDtlPayload
     * @return
     */
    Long updateByCondition(PrdEvaluateDtlPayload prdEvaluateDtlPayload);

    /**
     * evalId删除数据
     *
     * @param ids
     * @return
     */
    Long delByEvalIds(List<Long> ids);
}

