package com.elitesland.tw.tw5.api.prd.humanresources.service;

import java.util.List;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdLevelConfigPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdLevelConfigQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdLevelConfigVO;


import javax.servlet.http.HttpServletResponse;


/**
 * @author : WWW
 * @date : 2023-10-18
 * @desc : 级别维护表Service
 */

public interface PrdLevelConfigService {

    /**
     * 新增级别维护表数据
     * @param prdLevelConfigPayload
     * @return
     */
    PrdLevelConfigVO save(PrdLevelConfigPayload prdLevelConfigPayload);

    /**
     * 根据主键更新
     * @param prdLevelConfigPayload
     * @return
     */
    PrdLevelConfigVO update(PrdLevelConfigPayload prdLevelConfigPayload);

    /**
     * 根据主键获取详情
     * @param id
     * @return
     */
    PrdLevelConfigVO get(Long id);

    /**
     * 分页查询列表
     * @param prdLevelConfigQuery
     * @return
     */
    PagingVO<PrdLevelConfigVO> page(PrdLevelConfigQuery prdLevelConfigQuery);

    /**
     * 根据主键批量删除
     * @param ids
     * @return
     */
    Long del(List<Long> ids);


    /**
     * 获取级别列表集合
     * @param prdLevelConfigQuery
     * @return
     */
    List<PrdLevelConfigVO> getList(PrdLevelConfigQuery prdLevelConfigQuery);
}

