package com.elitesland.tw.tw5.api.prd.humanresources.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;


/**
 * @author : WWW
 * @date : 2023-10-19
 * @desc : 能力级别定义
 */

@Data
@ApiModel(description = "能力级别定义")
public class PrdAbilityLevelVO extends BaseViewModel {


    /**
     * 能力id
     */
    @ApiModelProperty("能力id")
    private Long abilityId;

    /**
     * 级别明细id
     */
    @ApiModelProperty("级别明细id")
    private Long levelDtlId;

    /**
     * 级别明细名称
     */
    @ApiModelProperty("级别明细名称")
    private String levelDtlName;

    /**
     * 类型 1单项能力2复合能力
     */
    @ApiModelProperty("类型 1单项能力2复合能力")
    private Integer type;

    /**
     * 获取方式
     */
    @ApiModelProperty("获取方式")
    private String obtainType;

    /**
     * 当量系数
     */
    @ApiModelProperty("当量系数")
    private BigDecimal dlRatio;

    /**
     * 能力描述
     */
    @ApiModelProperty("能力描述")
    private String abilityDesc;

    /**
     * 审核人类型
     */
    @ApiModelProperty("审核人类型")
    private String auditorType;

    /**
     * 审核人id
     */
    @ApiModelProperty("审核人id")
    private Long auditorId;

    /**
     * 审核人名称
     */
    @ApiModelProperty("审核人名称")
    private String auditorName;

}

